#version 330
#extension GL_EXT_gpu_shader4 : enable
//Lava in Julia lowlandsMod01.fsh  by  jin_x
//https://www.shadertoy.com/view/7dcSzr
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

#define iMouse AUTO_MOUSE
#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
#define RIGID_SCROLL
// alternatively use static mouse definition
//#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const int MAX_ITER = 64;
const int Z_STEP = 256 / MAX_ITER;

const float PARAM = 0.387;
const float ZOOM_COEF = 0.9;

const float ROT = 5.0;

const float PRE = 12.0;  //15.0;
const float DUR = 60.0;

const float PI = 3.14159265358979;
void main (void)
//void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
    float t = iTime - PRE;
    if (t > 0.0) {
        t = mod(t, DUR);
    	if (t >= DUR / 2.0) { t = DUR - t; }
    }
    float zoom = pow(ZOOM_COEF, t + PRE) * 0.667;
    
    float mxy = min(iResolution.x, iResolution.y);
    vec2 cxy = iResolution.xy / mxy;
    vec2 uv = (gl_FragCoord.xy / mxy - 0.5 * cxy) * 75.0 * zoom;
    
    // Rotate : x' = x*cos(a) - y*sin(a), y' = x*sin(a) + y*cos(a)
    
    float sa = sin(iTime/ROT), ca = cos(iTime/ROT);
    uv *= mat2(ca, -sa, sa, ca);
    
    // Julia : x = x^2 - y^2 + x, y = 2 * x * y + y
    
    int iter;
    gl_FragColor = vec4(1.0, 0.25, 0, 0);
    //gl_FragColor = vec4(0.2, 0.15, 3, 0);
   float x_param = cos(PI*1.5 - (t + PRE) / DUR * 4.3) * 0.8;
    float y_param = sin(PI*1.5 - (t + PRE) / DUR * 4.3) * 0.8;
    for (int z = MAX_ITER*2; z < MAX_ITER*3-1; ++z) {
        vec2 xy = uv * float(z) / float(MAX_ITER*5);
        for (iter = 0; iter <= z-MAX_ITER*2; ++iter) {
            vec2 xy2 = xy * xy;
            if (xy2.x + xy2.y > 4.0) { break; }
            xy = vec2(xy2.x - xy2.y + x_param, 2.0 * xy.x * xy.y + y_param);
        }
        if (iter <= z-MAX_ITER*2) {
            float c = float(MAX_ITER*3-1-z)/float(MAX_ITER);
            gl_FragColor = vec4(0.75-c/1.333, 1.0-c, c/2.0, 1.0);
            gl_FragColor.a = (length(gl_FragColor.rgb)*3.14159);
            break;
        }
    }

}